# 添加从库

在`主从复制`一节里，Joe实现了一个点对点的主从复制架构，现在，
Joe 要添加一个名为 backup 的新的从库，他应该怎么做？

简单起见，我们假设现在 trade 和 standby 已经配置为主从架构。

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

1. 在主库上建立来自从库backup的复制账号，授予复制权限 `GRANT REPLICATION SLAVE ON *.* TO 'user'@'backup';`
2. 修改从库配置（my.cnf），设定server_id以及binlog和relay-bin相关的信息
3. 重启从库
5. 在主库上执行 `FLUSH TABLES WITH READ LOCK;` 锁定
6. 在主库执行 `SHOW MASTER STATUS;` ，记录 binlog 文件及 Position 信息
7. 备份主库，生成备份文件，
8. 登录主库，执行``解锁主服务器
9. 在从库backup上用该备份恢复
10. 登录backup，配置主服务器的地址、端口、登录信息和binlog启动位置。
11. 在 backup 执行 `START slave;` 启动复制线程。

## 选项

### A

1. 编辑主库配置（my.cnf），设定server_id以及binlog和relay-bin相关的信息
2. 重启主库
3. 修改从库配置（my.cnf），设定server_id以及binlog和relay-bin相关的信息
4. 重启从库
5. 在主库上建立来自从库的复制账号
6. 在主库上执行 `FLUSH TABLES WITH READ LOCK;` 锁定
7. 在主库执行 `SHOW MASTER STATUS;` ，记录 binlog 文件及 Position 信息
8. 备份主库，生成备份文件，
9. 登录主库，执行``解锁主服务器
10. 在从库上用该备份恢复
11. 登录从库，配置主服务器的地址、端口、登录信息和binlog启动位置。
12. 在从库执行 `START slave;` 启动复制线程。
13. 重启从库

### B

重复《主从复制》一节的操作步骤，将 backup 配置成 standby 的从库

### C

所有选项都不对。