# 左匹配

Goods 表结构如下：

```sql
create table goods(
    id int primary key auto_increment,
    category_id int,
    name varchar(256),
    price decimal(12, 4),
    stock int,
    upper_time timestamp,
    index (category_id, name)
)
```

Joe 发现有大量查询 `select id, category_id, name, price from goods where name=? and category_id=?`，
性能很差，应该如何优化？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

将该查询改写为 

```sql
select id, 
       category_id, 
       name, 
       price 
from goods 
where category_id=? and name=?;
```

## 选项

### A

将该查询改写为

```sql
select id, 
       category_id, 
       name, 
       price 
from goods 
where category_id and name= (?, ?);
```

### B

将该查询改写为

```sql
select id, 
       category_id, 
       name, 
       price 
from goods 
where not (category_id !=? or name != ?);
```

### C

将该查询改写为

```sql
select id, 
       category_id, 
       name, 
       price 
from goods 
where not (category_id !=?) and not (name != ?);
```

