# Distinct

Joe 想统计以下 goods 表

```sql
create table goods(
    id int primary key auto_increment,
    category_id int,
    category varchar(64),
    name varchar(256),
    price decimal(12, 4),
    stock int,
    upper_time timestamp
)
```

中的商品有多少种不同的价格，他应该如何写这条查询？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select count(distinct price) 
from goods;
```

## 选项

### A

```sql
select count(distinct *) 
from goods;
```

### B

```sql
select distinct count(price) 
from goods;
```

### C

```sql
select count(price) 
from goods;
```

### D

```sql
select distinct price 
from goods;
```
