# 创建用户

Joe 要给数据组的 John 创建一个用户，他希望John 能够从 `192.168.7.42` 登录 goods 数据库查询数据，
用户第一次登录时使用密码 `goods123`，登录后必须设定一个新密码，那么应该用哪个语句？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
create user 'john'@'192.168.7.42' 
    identified by 'goods123' password expire;

grant select on goods.* to 'john'@'192.168.7.42';

flush privileges;
```

## 选项

### A

```sql
create user 'john'@'192.168.7.42' 
    identified by 'goods123';

grant select on goods.* to 'john'@'192.168.7.42';

flush privileges;
```

### B

```sql
create user 'john'@'192.168.7.42' 
    identified by 'goods123';

grant usage on 
    goods.* to 'john'@'192.168.7.42';

flush privileges;
```

### C

```sql
create user 'john'@'192.168.7.42' 
    identified by 'goods123' on database goods;

flush privileges;
```