# 唯一约束

现有一个图书登记表：

```sql
create table book(
    id int primary key auto_increment,
    title text,
    publish_at date,
    isbn text
)
```

我们发现有时候客户可能会重复输入同一本书的信息，*在不修改应用层程序的前提下*，怎样约束用户不会输入同一本书？

1. 删除id列，将isbn设置为主键
2. 在 isbn 列上加唯一约束
3. 执行 `create index on book(id, title, publish_at, isbn, meta)`
4. 在 id 键上加唯一约束

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

2

## 选项

### A

3

### B

4

### C

3 或 4

### D

3 和 4

### E

1 或 2