# Where 条件

Joe 希望从 orders 表

```sql
create table orders
(
    id          int primary key auto_increment,
    item_id     int,
    amount      int,
    unit_price  decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    ts          timestamp default now(),
    deal        bool      default false
);
```

查询 2022 年 5 月 25 日下单的所有单价低于 20 的订单id，那么这个查询应该如何写？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select id
from orders
where date(ts) = '2022-05-25'
  and unit_prise < 20;
```

## 选项

### A

```sql
select id
from (select * 
      from orders 
      where date(ts) = '2022-05-25') as o
where unit_prise < 20;
```

### B

```sql
select id
from orders
where date(ts) = '2022-05-25'
   or unit_prise < 20;
```

### C

```sql
select id
from orders 
if date(ts) = '2022-05-25' 
    or unit_prise < 20;
```

### D

```sql
select id
from orders
which date(ts) = '2022-05-25'
   or unit_prise < 20;
```
