import sqlalchemy as sa
from sqlalchemy.orm import Session


def connection():
    with open("connection.txt") as f:
        return f.read()


names = {
    "f": ["玲", "丽", "莉", "娟", "绢", "洁", "秀莉", "秀丽", "芳", "芬", "媛", "依依", "柔", "小小", "莉娅", "雪", "琳"],
    "m": ["森", "林", "强", "勇", "刚", "志强", "有德", "志勇", "利国", "利民", "毅", "腾", "骏", "雄", "烈", "铁"],
    "n": ["敏", "智", "鑫", "一", "秀", "远", "希夷", "俊", "英", "之", "芝", "月", "越", "跃", "粤",
          "云", "扬", "鸥"]
}

engine = sa.create_engine(connection())
session = Session(bind=engine)
tokens = []
for k in names:
    for w in names[k]:
        tokens.append((w, k))

for pair in tokens:
    name, tend_to = pair
    session.execute("insert ignore into last_name(label, sex_tend) select :label, :tend",
                    {"label": name, "tend": tend_to})
    print(name)
session.commit()
