# 复制过滤器

复制过滤器可以从主节点只复制一个或一部分数据库的数据到从节点上，并不是全部复制。关于 MySQL 复制架构的过滤器，以下说法<span style="color:red">错误</span>的是：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

设置过滤器后要重启整个集群的每个节点，以使其生效。

## 选项

### A

可以在主库中执行以下命令设定只复制 goods 数据库和 auth 数据库

```sql
SET GLOBAL binlog-do-db=goods,auth;
```

### B

可以在主库的 my.cnf 中配置只复制 goods 数据库和 auth 数据库

```
binlog-do-db=goods,auth
```

### C

可以在从库执行以下命令，设定只复制 goods 数据库和 auth 数据库

```sql
SET GLOBAL replicate-do-db=goods,auth;
```

### D

可以在从库执行以下命令，设定只复制 goods 数据库和 auth 数据库

```sql
CHANGE REPLICATION FILTER REPLICATE-DO-DB=(goods, order);
```

### E

可以在从库的 my.cnf 设定只复制 goods 数据库和 auth 数据库

```
replicate-do-db=goods,order;
```

### F

可以在主库中执行以下命令设定忽略 goods 数据库和 auth 数据库

```sql
SET GLOBAL binlog-ignore-db=goods,auth;
```

### G

可以在主库的 my.cnf 中配置忽略 goods 数据库和 auth 数据库

```
binlog-ignore-db=goods,auth
```

### H

可以在从库执行以下命令，设定忽略 goods 数据库和 auth 数据库

```sql
SET GLOBAL replicate-ignore-db=goods,auth;
```

### I

可以在从库执行以下命令，设定忽略 goods 数据库和 auth 数据库

```sql
CHANGE REPLICATION FILTER 
    REPLICATE_IGNORE_DB=(goods, auth);
```

### J

可以在从库的 my.cnf 设定忽略 goods 数据库和 auth 数据库

```
replicate-ignore-db=goods,order;
```

### K

可以在在从库的 MySQL 命令行设定只同步 goods 表和 orders 表

```sql
SET GLOBAL replicate-do-table=goods.goods,goods.orders;
```

### L

可以在在从库的 MySQL 命令行设定只同步 goods 表和 orders 表

```sql
CHANGE REPLICATION FILTER 
    REPLICATE_DO_TABLE=( goods.goods,goods.orders);
```

### M

可以配置从库的 my.cnf ，指定只复制 goods 表和 orders 表

```
replicate-do-table=goods.goods,goods.orders
```

### O

可以在在从库的 MySQL 命令行设定只同步名称前缀为 `t_` 的表

```sql
CHANGE REPLICATION FILTER 
    REPLICATE_WILD_DO_TABLE =( goods.t_%);
```

### P

可以在从库的 MySQL 命令行设定忽略 orders 和 trade 表

```sql
SET GLOBAL replicate-ignore-table=goods.orders,goods.trade;
```

### P

可以在从库的 MySQL 命令行设定忽略 orders 和 trade 表

```sql
CHANGE REPLICATION FILTER 
    REPLICATE_ IGNORE_TABLE=( goods.orders,goods.trade);
```


### Q

可以在从库的 my.cnf 配置设定忽略 orders 和 trade 表

```
replicate-ignore-table =goods.orders,goods.trade
```

### R

可以在在从库的 MySQL 命令行设定忽略名称前缀为 `o_` 的表

```sql
CHANGE REPLICATION FILTER 
    REPLICATE_WILD_DO_TABLE =( goods.o_%);
```

### S

设定过滤器时，可以指定通道，例如

```sql
CHANGE REPLICATION FILTER REPLICATE-DO-DB=(goods, auth) FOR CHANNEL ‘channel-name’;
```