# 多主复制架构

在上一节（主从复制）里，Joe实现了一个点对点的主从复制架构，现在，
Joe 要给交易库和用户库建立一个公用的从库，实现多主复制。假设主库
的服务器名为 trade 和 auth ，从库名为 standby 。 他应该如何操作？

我们假设现在是全新的环境，Trade、Auth 和 Standby 都是独立存在的 
MySQL 服务器。


<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

1. 分别编辑主库auth和trade的配置（my.cnf），设定server_id以及binlog和relay-bin相关的信息
2. 重启主库
3. 修改从库配置（my.cnf），设定server_id以及binlog和relay-bin相关的信息
4. 重启从库
5. 分别在主库服务器上建立来自从库的复制账号，授予复制权限 `GRANT REPLICATION SLAVE ON *.* TO 'user'@'standby';`
6. 在主库上执行 `FLUSH TABLES WITH READ LOCK;` 锁定
7. 在主库执行 `SHOW MASTER STATUS;` ，记录 binlog 文件及 Position 信息
8. 备份主库，生成备份文件，
9. 登录主库，执行`UNLOCK TABLES;`解锁主服务器
10. 在从库上用来自 trade 和 auth 的备份恢复
11. 登录从库，为两个主库分别配置不同的 `FOR CHNANEL`信息（例如这里设定为`autho-master`和`trade-master`），并对应配置主服务器的地址、端口、登录信息和binlog启动位置。
12. 在从库执行 `START SLAVE FOR CHANNEL 'autho-master';` 和 `START SLAVE FOR CHANNEL 'trade-master''`启动复制线程。
13. 重启从库

## 选项

### A

1. 分别编辑主库auth和trade的配置（my.cnf），设定server_id以及binlog和relay-bin相关的信息
2. 重启主库
3. 修改从库配置（my.cnf），设定server_id以及binlog和relay-bin相关的信息
4. 重启从库
5. 分别在主库服务器上建立来自从库的复制账号
6. 在主库上执行 `FLUSH TABLES WITH READ LOCK;` 锁定
7. 在主库执行 `SHOW MASTER STATUS;` ，记录 binlog 文件及 Position 信息
8. 备份主库，生成备份文件，
9. 登录主库，执行`UNLOCK TABLES;`解锁主服务器
10. 在从库上用来自 trade 和 auth 的备份恢复
11. 登录从库,配置主服务器的地址(将两个主服务器用逗号分开)、端口、登录信息和binlog启动位置。
12. 在从库执行 `START SLAVE';`启动复制线程。
13. 重启从库

### B

1. 重复《主从复制》一节的操作步骤，将 trade 配置成 auth 的从库
2. 重复《主从复制》一节的操作步骤，将 standby 配置成 trade 的从库

### C

所有选项都不对。