# 从主从复制到链式复制

在`添加从库`一节里，Joe实现了一个一对多的主从结构。standby 和 backup 都是trade 的从库。
现在，Joe 需要将 backup 修改为 standby 的从节点，实现链式复制。

他应该如何操作？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

1. 在 standby 和 backup 上分别执行 `STOP SLAVE`，停止复制
2. 在 standby 和 backup 上分别执行 `SHOW SLAVE STATUS;`，查看 `Relay_Master_Log_File` 和 `Exec_Master_Log_Pos` 是否一致
3. 如果状态一致，进入第 5 步。
4. 如果不一致，在 pos 靠前的服务上执行 `START SLAVE UNTIL MASTER_LOG_FILE='$file', Master_Log_Pos=$pos;`， 
   将变更同步到与另一台服务器一致。这里的 `$file` 和 `$pos` 即状态较新的那台服务器的状态值。
5. 在 standby 上创建用于 backup 连接的复制账号，授予复制权限 `GRANT REPLICATION SLAVE ON *.* TO 'user'@'backup';`
6. 在 standby 执行 `SHOW MASTER STATUS;` 获得其 binlog 文件和 position 值。 
7. 在 standby 执行 `START SLAVE`，启动复制过程。
8. 在 backup 服务器执行 `STOP SLAVE;` ，停止复制
9. 在 backup 设定 standby 服务器的地址、端口、登录信息和binlog启动位置，作为主库信息。
10. 在 backup 执行 `START slave;` 启动复制线程。

## 选项

### A

1. 在 standby 和 backup 上分别执行 `STOP SLAVE`，停止复制
2. 在 standby 和 backup 上分别执行 `SHOW SLAVE STATUS;`，查看 `Relay_Master_Log_File` 和 `Exec_Master_Log_Pos` 是否一致
3. 如果状态一致，进入第 5 步。
4. 如果不一致，在 pos 靠前的服务上执行 `START SLAVE UNTIL MASTER_LOG_FILE='$file', Master_Log_Pos=$pos;`，
   将变更同步到与另一台服务器一致。这里的 `$file` 和 `$pos` 即状态较新的那台服务器的状态值。
5. 在 standby 上创建用于 backup 连接的复制账号
6. 备份 standby 。
7. 在 standby 执行 `START SLAVE`，启动复制过程。
8. 在 backup 服务器执行 `STOP SLAVE;` ，停止复制
9. 用standby 的备份文件恢复 backup。
10. 在 backup 执行 `START slave;` 启动复制线程。

### B

1. 在 standby 和 backup 上分别执行 `STOP SLAVE`，停止复制
2. 在 standby 和 backup 上分别执行 `SHOW SLAVE STATUS;`，查看 `Relay_Master_Log_File` 和 `Exec_Master_Log_Pos` 是否一致
3. 在 standby 上创建用于 backup 连接的复制账号
4. 在 standby 执行 `SHOW MASTER STATUS;` 获得其 binlog 文件和 position 值。
5. 在 standby 执行 `START SLAVE`，启动复制过程。
6. 在 backup 服务器执行 `STOP SLAVE;` ，停止复制
7. 在 backup 设定 standby 服务器的地址、端口、登录信息和binlog启动位置，作为主库信息。
8. 在 backup 执行 `START slave;` 启动复制线程。


### C

所有选项都不对。