# 主从复制

Joe 要给交易库建立一个从库，实现主从复制。假设主库的服务器名为 trade ，从库名为 standby 。
他应该如何操作？

1. 编辑主库配置（my.cnf），设定server_id以及binlog和relay-bin相关的信息
2. 重启主库
3. 修改从库配置（my.cnf），设定server_id以及binlog和relay-bin相关的信息
4. 重启从库
5. 在主库上建立用于从库连接的复制账号，授予复制权限 `GRANT REPLICATION SLAVE ON *.* TO 'user'@'standby';`
6. 在主库上执行 `FLUSH TABLES WITH READ LOCK;` 锁定
7. 在主库执行 `SHOW MASTER STATUS;` ，记录 binlog 文件及 Position 信息
8. 备份主库，生成备份文件，
9. 登录主库，执行``解锁主服务器
10. 在从库上用该备份恢复
11. 登录从库，配置主服务器的地址、端口、登录信息和binlog启动位置。
12. 在从库执行 `START slave;` 启动复制线程。
13. 重启从库

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```
1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13
```

## 选项

### A

```
1, 2, 3, 4, 5, 6
```

### B

```
12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1
```

### C

```
2, 4, 6, 8, 10, 12
```