# 判断

Goods 数据库中有一个名为 trade 的存储过程，封装了交易过程，每一笔交易，trade都会被调用一次。Joe 
想在 trade 里加一段逻辑，实现：

1. 每一次交易，对 @counter 变量加一
2. 如果 @counter 是 1000 的整倍数，就将 @total_price 变量乘 0.8。

下面哪一段代码可以实现这个逻辑？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
set @counter = @counter + 1;
if @counter % 1000 = 0 then
    set @total_price = @total_price * 0.8;
end if;
```

## 选项

### A

```sql
set @counter = @counter + 1;
if @counter % 1000 = 0 {
    set @total_price = @total_price * 0.8;
}
```

### B

```sql
set @counter = @counter + 1;
if (@counter % 1000 = 0) {
    set @total_price = @total_price * 0.8;
}
```

### C

```sql
if @counter % 1000 = 0 begin ;
    set @total_price = @total_price * 0.8;
end;
```

### D

```sql
set @counter ++;
if @counter % 1000 = 0 then begin 
    select @total_price = @total_price * 0.8;
end;
```