# 组合索引

Goods 表结构如下：

```sql
create table goods(
    id int primary key auto_increment,
    category_id int,
    category varchar(64),
    name varchar(256),
    price decimal(12, 4),
    stock int,
    upper_time timestamp
)
```

现有大量查询 
```sql
select 
    id, 
    category_id, 
    name, 
    price, 
    stock 
from goods 
where stock=? 
  and category_id=? 
  and name like ?`，
```
Joe 应该如何优化？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
alter table goods 
    add index (stock, category_id, name);
```

## 选项

### A

```sql
alter table goods 
    add index (stock and category_id and name);
```

### B

```sql
alter table goods 
    add index (concat(stock, category_id, name));
```

### C

```sql
alter table goods 
    add index (stock + category_id + name);
```
