# 全值匹配

Goods 表结构如下：

```sql
create table goods(
    id int primary key auto_increment,
    category_id int,
    name varchar(256),
    price decimal(12, 4),
    stock int,
    upper_time timestamp
)
```

现在有大量根据商品名获取价格的查询`select price from goods where name = '...''`，Joe希望进行优化，那么他应该：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
alter table goods 
    add index (name, price);
```

## 选项

### A

将 name 和 price 合成一个字段。

### B

建立一个计算字段：

```sql
alter table goods 
    add summary varchar(1024) 
        generated always as (concat(name, '(', 0.5, ')'));
```

### C

```sql
alter table goods 
    add index (concat(name, price));
```