# Having

 Joe 要从 employee 表
 
```sql
create table employee
(
    id     serial primary key,
    name   varchar(256),
    dept   varchar(256),
    salary decimal(12, 4)
);
```

中得到每月工资开支超过十万的部门，这个查询应该怎么写？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
select dept 
from employee 
group by dept 
having sum(salary) > 100000;
```

## 选项

### A

```sql
select dept 
from employee 
group by dept where sum(salary) > 100000;
```

### B

```sql
select dept 
from employee 
where sum(salary) > 100000 
group by dept;
```

### C

```sql
select dept 
from employee 
where sum(salary) > 100000 
order by dept;
```

### D

```sql
select dept 
from employee 
group by dept 
where sum(salary) > 100000;
```


