# 灾难恢复选项

设定 `innodb_force_recovery` 的值时，可选的有哪些？

1. (SRV_FORCE_IGNORE_CORRUPT)：忽略损坏的数据页，继续运行MySQL服务。
2. (SRV_FORCE_NO_BACKGROUND)：防止主线程和任何清除线程运行。如果清除操作期间发生崩溃，则此恢复值将阻止崩溃。
3. (SRV_FORCE_NO_TRX_UNDO)：在崩溃后不运行事务回滚操作。
4. (SRV_FORCE_NO_IBUF_MERGE)：不执行插入缓冲的合并操作，此值可能会永久损坏数据文件。使用此值后，需要删除并重新创建所有辅助索引，并且需要将InnoDB设置为只读。
5. (SRV_FORCE_NO_UNDO_LOG_SCAN)：不查看重做日志，InnoDB存储引擎会将未提交的事务视为已提交。此值可能会永久损坏数据文件，需要将InnoDB设置为只读。
6. (SRV_FORCE_NO_LOG_REDO)：不执行与恢复相关重做日志的前滚操作。此值可能会永久损坏数据文件，使数据库页处于过时状态，这反过来又可能导致B树和其他数据库结构的损坏，需要将InnoDB设置为只读。

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

全部都是

## 选项

### A

```
2, 3, 4, 5
```

### B

```
1, 2, 3, 4, 5
```


### C

```
1, 2, 4
```