# 创建存储过程

计算个人所得税的函数 individual_income_tax 很好用，但是每次要保存税额和税后工资，
Joe 希望这个计算更紧凑一些，在已经有 individual_income_tax 的前提下，Joe 决定
写一个存储过程 sp_idt ，同时生成所得税和税后工资。这个存储过程的声明应该是：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
create procedure sp_idt(
    in salary decimal(12, 4), 
    out tax decimal(12, 4), 
    out take_home decimal(12, 4)) 
begin 
    set tax = individual_income_tax(salary);
    set take_home = salary - tax;
end;
```

## 选项

### A

```sql
create procedure sp_idt(salary decimal(12, 4)) 
    returns (tax decimal(12, 4), 
        take_home decimal(12, 4))
begin 
    set tax = individual_income_tax(salary);
    set take_home = salary - tax;
end;
```

### B


```sql
create procedure sp_idt(salary decimal(12, 4)) 
    returns (decimal(12, 4), decimal(12, 4))
begin 
    declare tax, take_home decimal(12, 4);
    set tax = individual_income_tax(salary);
    set take_home = salary - tax;
    return (tax, take_home);
end;
```

### C

```sql
create procedure sp_idt(in salary decimal(12, 4), out tax decimal(12, 4), out take_home decimal(12, 4)) returns void
begin 
    set tax = individual_income_tax(salary);
    set take_home = salary - tax;
end;
```

### D

```sql
create procedure sp_idt(in salary decimal(12, 4)) 
begin
    declare tax, take_home decimal(12, 4);
    set tax = individual_income_tax(salary);
    set take_home = salary - tax;
    select tax, take_home;
end;
```