# 删除

现在 orders 表结构如下：

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    ts timestamp default now(),
    deal bool default false
);
```

有一个业务系统会实时的将已经成交（deal 字段为 true）的订单数据转储，现在我们仅需要一个清理 程序，将已经成 交的数据从 orders 表删除。下面哪个操作是对的？

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

在一个独立的定时任务中执行

```sql
delete
from orders
where deal;
```

## 选项

### A

在一个独立的定时任务中执行

```sql
truncate orders;
```

### B

在一个独立的定时任务中执行

```sql
delete
from orders;
```

### C

在一个独立的定时任务中执行

```sql
drop table orders;
create table if not exists orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    ts timestamp default now(),
    deal bool default false
);
```

### D

建立视图

```sql
create view order_view as
select id, meta, content, created_at
from orders
where not deal;
```

并要求业务系统只能访问这个视图。

### E

在一个独立的定时任务中执行

```sql
delete
from orders
where deal;
```

并记录操作前后表中的最大 id
