# 二进制字符串

现在 Joe 的订单表已经有了如下形态：

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    ts timestamp default now()
);
```

他需要添加一个字段，用来保存订单的相关图片，由于特殊的业务需要，这些图片必须保存在数据库中，图片的大小不超过100K。那么他应该将建表语句修改为：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    picture blob,
    ts timestamp default now()
);
```

## 选项

### A

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    picture varchar(100000),
    ts timestamp default now()
);
```

### B

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    picture text,
    ts timestamp default now()
);
```

### C

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    picture binary(100000),
    ts timestamp default now()
);
```

### D

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    picture varbinary(100000),
    ts timestamp default now()
);
```
