# 文本字段

Joe 在设计订单表，他已经完成了下列内容：

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    ts timestamp default now()
);
```

现在他需要给订单表加入一个 description 字段，这个字段需要保存订单的文字说明，这些文本不会超过两千字节， Joe 应该把建表语句修改为：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    ts timestamp default now()
);
```

## 选项

### A

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description char(2000),
    ts timestamp default now()
);
```

### B

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(256) default '',
    ts timestamp default now()
);
```

### C

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description text(2000),
    ts timestamp default now()
);
```

### D

```sql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description tinytext(2000),
    ts timestamp default now()
);
```