# 自增字段

Joe 需要重建一个 id 为自增字段的 goods_category 。他已经删除了旧表，那么接下来应该：

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

## 答案

```sql
CREATE TABLE goods_category
(
    id         INT PRIMARY KEY AUTO_INCREMENT,
    category VARCHAR(30),
    remark   VARCHAR(100)
) ENGINE INNODB;
```

## 选项

### A

```sql
CREATE TABLE goods_category
(
    id         INT PRIMARY KEY SERIALS,
    category VARCHAR(30),
    remark   VARCHAR(100)
) ENGINE INNODB;
```

### B

```sql
CREATE TABLE goods_category
(
    id         INT ,
    category VARCHAR(30),
    remark   VARCHAR(100),
    PRIMARY KEY ID AUTO_INCREMENT
) ENGINE INNODB;
```


### C

```sql
CREATE TABLE goods_category
(
    id         INT PRIMARY KEY,
    category VARCHAR(30),
    remark   VARCHAR(100)
) ENGINE INNODB;
```

### D

```sql
CREATE TABLE goods_category
(
    id         INT PRIMARY KEY SERIALS,
    category VARCHAR(30),
    remark   VARCHAR(100)
) ENGINE INNODB;
```
