# 初始化账户

Joe 已经在自己的开发机安装好 MySQL，他现在有一个系统用户 joe，该用户有 sudo 权限。

现在他想要建立一个名为 joe 的开发用户，并且：
 - 这个用户*只能*在本机登录
 - 使用简单的口令 `joe`
 - 要有足够高的权限，用于接下来的开发工作

那么，Joe 应该采用下列哪个方案

<hr/>

点击进入[MySQL实战练习环境](https://mydev.csdn.net/product/pod/new?image=cimg-centos7-skilltreemysql&connect=auto&create=auto&utm_source=skill){target="_blank"}。

* `show databases;` 列出所有数据库
* `show tables;` 列出所有表

##  答案

以 root 登录到本机的 mysql 库
```shell
sudo su
mysql mysql
```
创建数据库用户 joe 并授权：
```sql
create user 
    'joe'@'localhost' 
        identified by 'joe';

grant all privileges 
    on *.* to `joe`@`localhost`;

flush privileges ;
```

## 选项


### A

以 joe 用户名登录数据库
```shell
mysql mysql
```
为 joe 授权
```sql
grant all 
    privileges on *.* to joe;

flush privileges ;
```

### B

以 root 用户登录数据库
```shell
sudo su
mysql mysql
```

为 joe 授权
```sql
grant all 
    privileges on *.* to joe;

flush privileges ;
```

### C

以 joe 用户登录数据库
```shell
mysql mysql
```

创建数据库用户 joe
```sql
create user 
    'joe'@'localhost' 
        identified by 'joe';

flush privileges ;
```

### D

以 root 登录到本机的 mysql 库
```shell
sudo su
mysql mysql
```
创建数据库用户 joe 并授权：
```sql
create user 
    'joe'@'%' 
        identified by 'joe';

grant all 
    privileges on *.* to joe;

flush privileges ;
```
