# 个人所得税计算

个人所得税的计算需要进行若干指标的求和，然后基于分段的基数和系数计算得到扣税金额。
因此 Joe 准备用一个存储过程或函数将个人所得税计算封装起来，供团队使用，那么，下列
措施中哪一项是错误的？

## 答案

通过 `create function iitax(amount decimal(12, 4), out tax decimal(12, 4)， out rest decimal(12, 4)) ` 
定义个人所得税计算函数。

## 选项

### A

通过 `create function iitax(amount decimal(12, 4)) returns decimal(12, 4)` 定义个人所得税计算函数。

### B

通过 `create procedure(amount decimal(12, 4), out tax decimal(12, 4)， out rest decimal(12, 4))` 
定义计算过程，将税金和剩余金额通过 out 参数传递出来。

### C

通过 `select iitax(amount)` 可以调用 iitax 函数得到所得税金额。


### D

通过 `call iitax(amount, @tax, @rest)` 可以求得 amount 对应的个人所得税金额，
并将税额和剩余金额保存在 `@tax` 和 `@rest` 变量中。 