# 唯一约束

现有一个图书登记表：

```mysql
create table book(
    id int primary key auto_increment,
    title text,
    publish_at date,
    isbn text
)
```

我们发现有时候客户可能会重复输入同一本书的信息，怎样约束用户不会输入同一本书？

1. 删除id列，将isbn设置为主键
2. 在 isbn 列上加唯一约束
3. 执行 `create index on book(id, title, publish_at, isbn)`
4. 在 id 键上加唯一约束

## 答案

1 或者 2

## 选项

### A

3

### B

4

### C

3 或 4

### D

3 和 4
