# 建表语句

现在Joe 需要建立一个简化的交易流水表 trade，需要一个自增主键，一个content字段保存订单详情，，
需要有一个时间戳字段记录订单入库时间，那么哪一个语句是对的？

## 答案

```mysql
create table trade (
    id int primary key auto_increment,
    content varchar(8000),
    created_at timestamp default now()
);
```

## 选项

### 主键没有设置自增，不符合题意

```mysql
create table trade (
    id integer primary key,
    content varchar(8000),
    created_at timestamp default now()
);
```

### 时间戳没有设置默认值

```mysql
create table trade (
    id serial primary key,
    content varchar(8000),
    created_at timestamp
);
```

###  没有主键，不符合题设

```mysql
create table trade (
    id serial,
    content varchar(8000),
    created_at timestamp default now()
);
```