# Where 条件

Joe 希望从 orders 表

```mysql
create table orders
(
    id          int primary key auto_increment,
    item_id     int,
    amount      int,
    unit_price  decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    ts          timestamp default now(),
    deal        bool      default false
);
```

查询 2022 年 5 月 25 日下单的所有单价低于 20 的订单id，那么这个查询应该如何写？

## 答案

```mysql
select id
from orders
where date(ts) = '2022-05-25'
  and unit_prise < 20;
```

## 选项

### A

```mysql
select id
from (select * from orders where date(ts) = '2022-05-25') as o
where unit_prise < 20;
```

### B

```mysql
select id
from orders
where date(ts) = '2022-05-25'
   or unit_prise < 20;
```

### C

```mysql
select id
from orders 
if date(ts) = '2022-05-25' or unit_prise < 20;
```

### D

```mysql
select id
from orders
which date(ts) = '2022-05-25'
   or unit_prise < 20;
```
