# 删除

现在 orders 表结构如下：

```mysql
create table orders (
                        id int primary key auto_increment,
                        item_id int,
                        amount int,
                        unit_price decimal(12, 4),
                        price decimal(12, 4),
                        description varchar(2000),
                        ts timestamp default now(),
                        deal bool default false
);
```

有一个业务系统会实时的将已经成交（deal 字段为 true）的订单数据转储，现在我们仅需要一个清理 程序，将已经成 交的数据从 orders 表删除并记录被删除的数据id。下面哪个操作是对的？

## 答案

在一个独立的定时任务中执行

```mysql
delete
from orders
where deal;
```

## 选项

### A

在一个独立的定时任务中执行

```mysql
truncate orders;
```

### B

在一个独立的定时任务中执行

```mysql
delete
from orders;
```

### C

在一个独立的定时任务中执行

```mysql
drop table orders;
create table if not exists orders (
                        id int primary key auto_increment,
                        item_id int,
                        amount int,
                        unit_price decimal(12, 4),
                        price decimal(12, 4),
                        description varchar(2000),
                        ts timestamp default now(),
                        deal bool default false
);
```

### D

建立视图

```mysql
create view order_view as
select id, meta, content, created_at
from orders
where not deal;
```

并要求业务系统只能访问这个视图。

### E

在一个独立的定时任务中执行

```mysql
delete
from orders
where deal;
```

并记录操作前后表中的最大 id