# 插入

Goods 数据库中有一个表：

```mysql
create table book(
    id int primary key auto_increment,
    title varchar(200) not null ,
    description varchar(1000) default '',
    price decimal(12, 4),
    isbn char(16) not null ,
    publish_at date not null 
);
create unique index idx_book_isbn on book(isbn);
```

那么下列哪个选项的代码可以执行成功？

## 答案

```mysql
insert into book(title, price, isbn, publish_at) select 'a book title', 25.4, 'xx-xxxx-xxxx', '2019-12-1';
insert into book(title, price, isbn, publish_at) select 'a other book title', 25.4, 'yy-yyyy-xxxx', '2019-12-1'; 
```

## 选项

### 唯一键冲突

```mysql
insert into book(title, price, isbn, publish_at) select 'a book title', 25.4, 'xx-xxxx-xxxx', '2019-12-1';
insert into book(title, price, isbn, publish_at) select 'a other book title', 35.4, 'xx-xxxx-xxxx', '2019-12-1'; 
```

### 缺少必要的列

```mysql
insert into book(price, isbn, publish_at) select 25.4, 'xx-xxxx-xxxx', '2019-12-1';
insert into book(price, isbn, publish_at) select 35.4, 'yy-yyyy-xxxx', '2019-12-1';
```

### 类型错误

```mysql
insert into book(title, price, isbn, publish_at) select 'a book title', 'unknown', 'xx-xxxx-xxxx', '2019-12-1';
insert into book(title, price, isbn, publish_at) select 'a other book title', 'unknown', 'xx-xxxx-xxxx', '2019-12-1';
```

### 违反非空约束

```mysql
insert into book(title, price, isbn, publish_at) select null, 'unknown', 'xx-xxxx-xxxx', '2019-12-1';
insert into book(title, price, isbn, publish_at) select null, 'unknown', 'xx-xxxx-xxxx', '2019-12-1';
```
