# 二进制字符串

现在 Joe 的订单表已经有了如下形态：

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    ts timestamp default now()
);
```

他需要添加一个字段，用来保存订单的相关图片，由于特殊的业务需要，这些图片必须保存在数据库中，图片的大小不超过100K。那么他应该将建表语句修改为：

## 答案

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    picture blob,
    ts timestamp default now()
);
```

## 选项

### A

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    picture varchar(100000),
    ts timestamp default now()
);
```

### B

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    picture text,
    ts timestamp default now()
);
```

### C

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    picture binary(100000),
    ts timestamp default now()
);
```

### D

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    description varchar(2000),
    picture varbinary(100000),
    ts timestamp default now()
);
```
