# 时间默认值

Joe 写了一个订单表的创建语句：

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4)
);
```

现在，Joe 需要给这个表加入下单时间，即订单写入数据库的时间，那么他应该将这个语句修改为：

## 答案

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    ts timestamp default now()
);
```

## 选项

### A

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    ts varchar(16) default now()
);
```

### B

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    ts varchar(16) format 'yyyy-mm-dd'
);
```

### C

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    ts date default now()
);
```

### D

```mysql
create table orders (
    id int primary key auto_increment,
    item_id int,
    amount int,
    unit_price decimal(12, 4),
    price decimal(12, 4),
    ts datetime default now()
);
```
