# 自增字段

Joe 需要重建一个 id 为自增字段的 goods_category 。他已经删除了旧表，那么接下来应该：

## 答案

```mysql
CREATE TABLE goods_category
(
    id         INT PRIMARY KEY AUTO_INCREMENT,
    category VARCHAR(30),
    remark   VARCHAR(100)
) ENGINE INNODB;
```

## 选项

### A

```mysql
CREATE TABLE goods_category
(
    id         INT PRIMARY KEY SERIALS,
    category VARCHAR(30),
    remark   VARCHAR(100)
) ENGINE INNODB;
```

### B

```mysql
CREATE TABLE goods_category
(
    id         INT ,
    category VARCHAR(30),
    remark   VARCHAR(100),
    PRIMARY KEY ID AUTO_INCREMENT
) ENGINE INNODB;
```


### C

```mysql
CREATE TABLE goods_category
(
    id         INT PRIMARY KEY,
    category VARCHAR(30),
    remark   VARCHAR(100)
) ENGINE INNODB;
```

### D

```mysql
CREATE TABLE goods_category
(
    id         INT PRIMARY KEY SERIALS,
    category VARCHAR(30),
    remark   VARCHAR(100)
) ENGINE INNODB;
```
