# 配置项优化

Joe 要帮助开发部优化交易数据库的性能，下面哪些优化是可能有帮助的？

1. 适当增大MySQL的最大连接数 max_connections， 提高并发响应能力。
2. 适当增大 table_cache，提高同时打开表的个数。此参数需根据业务需要有节制的上调
3. 适当增大 table_open_cache，提高数据表的缓存数量。
4. 适当调整 innodb_buffer_pool_size：此配置项决定着InnoDB存储引擎的数据表的数据和索引数据的最大缓冲区大小。一般可以分配80%的物理内存。
5. 适当增加 innodb_log_buffer_size，减少频繁的日志写操作。
6. 如果存在较多的排序操作，调整 sort_buffer_size：排序缓冲区的大小。
7. read_buffer_size：数据表的读缓冲区。适当增加此配置项的值，能够提高MySQL的并发读能力。
8. back_log：如果MySQL服务器需要在短时间内处理大量的连接请求，则可以适当增大此配置项的值。
9. thread_cache_size：MySQL缓存的数据库服务线程的最大线程数。当有大量客户端连接MySQL时，可以适当增大此配置项的值。
10. innodb_lock_wait_timeout：InnoDB存储引擎等待行锁的时间，默认值为50ms。对于实时要求高的应用，可以将此配置项的值适当调小。

## 答案

全部都是

## 选项

### A

```
1, 2, 3, 4, 5
```

### B

```
1, 2, 3, 4, 5, 6, 7, 8
```

### C

```
1, 2, 3, 4, 5, 6, 7, 8
```

### D

```
4, 5, 6, 7, 8
```



