# 批量写入

Joe 需要为数据组准备一个离线数据库，这个数据库的数据量很大。
下面这些措施中有哪些可以帮助 Joe 更快的写入这些数据？

1. 使用`ALTER TABLE t_table_name DISABLE KEYS;`禁用索引，完成工作后用`ALTER TABLE t_table_name ENABLE KEYS;`启用索引
2. 使用`SET UNIQUE_CHECKS = 0;`禁用唯一性检查，完成工作后用`SET UNIQUE_CHECKS = 1;`恢复唯一性检查
3. 使用`SET foreign_key_checks = 0;`禁用外键检查，完成工作后`SET foreign_key_checks = 1;`恢复外键检查
4. 使用`insert values(...),(...),(...)...`批量插入数据
5. 使用`LOAD DATA INFILE ‘data_file_path’ INTO TABLE table_name;`批量导入数据
6. 对 InnoDB 表使用 `SET autocommit = 0;` 禁用自动事务，完成工作后用 `SET autocommit = 1;`

## 答案

全部都对

## 选项

### A

```
1, 2, 3, 4, 5
```

### B

```
2, 3, 4, 5
```

### C

```
2, 3, 4, 6
```

### D

```
1, 2, 3, 4
```

### D

```
3, 4, 5, 6
```

### E

```
3, 4
```