# Having

 Joe 要从 employee 表
 
```mysql
create table employee
(
    id     serial primary key,
    name   varchar(256),
    dept   varchar(256),
    salary decimal(12, 4)
);
```

中得到每月工资开支超过十万的部门，这个查询应该怎么写？

## 答案

```mysql
select dept from employee group by dept having sum(salary) > 100000;
```

## 选项

### A

```mysql
select dept from employee group by dept where sum(salary) > 100000;
```

### B

```mysql
select dept from employee where sum(salary) > 100000 group by dept;
```

### C

```mysql
select dept from employee where sum(salary) > 100000 order by dept;
```

### D

```mysql
select dept from employee group by dept where sum(salary) > 100000;
```


