# 视图

Joe 需要给 goods 表

```mysql
create table goods(
    id int primary key auto_increment,
    category_id int,
    category varchar(64),
    name varchar(256),
    price decimal(12, 4),
    stock int,
    upper_time timestamp
)
```

添加一个视图，仅展示价格超过 1000 的商品价格和名称，下列选项中正确的是：

## 答案

```mysql
CREATE VIEW view_name_price 
    AS 
    SELECT name, price 
    FROM goods
    WHERE price > 1000;
```

## 选项

### A

```mysql
CREATE VIEW view_name_price 
    AS 
    SELECT name, price 
    FROM goods;
```

### B

```mysql
CREATE VIEW view_name_price 
    AS 
    SELECT * 
    FROM goods
    WHERE price > 1000;
```

### C

```mysql
CREATE VIEW view_name_price
    AS 
BEGIN
    SELECT name, price
    FROM goods
    WHERE price > 1000;
END;
```

### D

```mysql
CREATE VIEW view_name_price
    AS 
BEGIN
    SELECT name, price
    FROM goods
    WHERE price > 1000;
END;
```
