# 数值计算

Points 表结构如下：

```mysql
create table points(
    id int primary key auto_increment,
    x float,
    y float
)
```

现在 Joe 想要求写一个查询，得到每个点的id和模。即 √(x^2+y^2) 。这个查询应该是：

## 答案

```mysql
select id, sqrt(x^2 + y^2) from points;
```

## 选项

### A

```mysql
select sqrt(vx+vy) from (select x^2 as vx, y^2 as vy from points) as t;
```

### B

```mysql
select sqrt(vx + vy) from points where x^2 as vx, y^2 as vy ;
```

### C

```mysql
select id + sqrt(x^2 + y^2) from points;
```

### D

```mysql
select id || sqrt(x^2 + y^2) from points;
```