# 存储引擎

Joe 需要确保 goods_category 表的存储引擎为 innodb ，那么建表语句应该是：

## 答案

```mysql
CREATE TABLE goods_category
(
    id         INT,
    category VARCHAR(30),
    remark   VARCHAR(100)
) ENGINE=INNODB;
```

## 选项

### A

```mysql
CREATE TABLE goods_category
(
    id         INT,
    category VARCHAR(30),
    remark   VARCHAR(100)
) as INNODB;
```

### B

```mysql
WITH ENGINE=INNODB CREATE TABLE goods_category
(
    id         INT,
    category VARCHAR(30),
    remark   VARCHAR(100)
);
```

### C

```mysql
SAVE TABLE goods_category
(
    id         INT,
    category VARCHAR(30),
    remark   VARCHAR(100)
) AS INNODB;
```

### D

```mysql
CREATE TABLE goods_category
(
    id         INT,
    category VARCHAR(30),
    remark   VARCHAR(100)
) INNODB;
```

