# 初始化账户

Joe 已经在自己的开发机安装好 MySQL，他现在有一个系统用户 joe，该用户有 sudo 权限。

现在他想要建立一个名为 joe 的开发用户，并且：
 - 这个用户*只能*在本机登录
 - 使用简单的口令 `joe`
 - 要有足够高的权限，用于接下来的开发工作

那么，Joe 应该采用下列哪个方案

##  答案

以 root 登录到本机的 mysql 库
```shell
sudo su
mysql mysql
```
创建数据库用户 joe 并授权：
```mysql
create user 'joe'@'localhost' identified by 'joe';
grant all privileges on *.* to `joe`@`localhost`;
flush privileges ;
```

## 选项


### A

以 joe 用户名登录数据库
```shell
mysql mysql
```
为 joe 授权
```mysql
grant all privileges on *.* to joe;
flush privileges ;
```

### B

以 root 用户登录数据库
```shell
sudo su
mysql mysql
```

为 joe 授权
```mysql
grant all privileges on *.* to joe;
flush privileges ;
```

### C

以 joe 用户登录数据库
```shell
mysql mysql
```

创建数据库用户 joe
```mysql
create user 'joe'@'localhost' identified by 'joe';
flush privileges ;
```

### D

以 root 登录到本机的 mysql 库
```shell
sudo su
mysql mysql
```
创建数据库用户 joe 并授权：
```mysql
create user 'joe'@'%' identified by 'joe';
grant all privileges on *.* to joe;
flush privileges ;
```
