# 事务

现有 test1 表如下

```postgresql
create table test1(a integer primary key );
```

我们执行下面的语句

```postgresql
CREATE PROCEDURE transaction_test1()
LANGUAGE plpgsql
AS $$
BEGIN
    FOR i IN 0..9 LOOP
        INSERT INTO test1 (a) VALUES (i);
        IF i % 2 = 0 THEN
            COMMIT;
        ELSE
            ROLLBACK;
        END IF;
    END LOOP;
END;
$$;

CALL transaction_test1();
```

时，下面哪一项的解释是对的？

## 答案

每当循环迭代到偶数的时候提交插入，最终 test1 表中是`0,2,4,6,8`。

## 选项

### A

以最后一次提交为准，最终 test1 表中是 0 到 9 共九个数字。

### B

所有插入都回滚了。test1 表中没有数据。

### C

这个过程执行会报错。