# 子查询

现有员工表

```postgresql
create table employee
(
    id     serial primary key,
    name   text,
    dept   text,
    salary money
)
```

我们希望找出比销售部（dept 为 sale）工资最高的员工工资更高的那部分人，查询出他们的完整信息，下面哪一项可以满足要求？

## 答案

```postgresql
select id, name, dept, salary
from employee
where salary > (select max(salary)
                from employee
                where dept = 'sale')
```

## 选项

### A

```postgresql
select id, name, dept, salary
from employee
where dept = 'sale'
group by dept
having salary > max(salary)
```

### B

```postgresql
select l.id, l.name, l.dept, l.salary
from employee as l
         join employee as r on l.salary > max(r.salary)
where r.dept = 'sale'
group by r.dept 
```

### C

```postgresql
select id, name, dept, salary
from employee
having salary > (select max(salary) from employee where dept = 'sale')
```



