# Lambda 表达式

下面这个 lambda 表达式，它的类型不可能是什么？ 

```java
x -> {
    return x %2 == 0;
}
```

## 答案

```java
Function<int, bool>
```

## 选项

### 可以是 Function

```java
Function<Integer, Boolean>
```

### 可以是 Predicate

```java
Predicate<Integer>
```

### 可以是自定义的 SAM

```java
public interface Parsec{
    Boolean ask(Integer value);
}
```

### 可以是泛型的 SAM

```java
public interface Parsec<T, R>{
    R ask(T value);
}
```
