# 函数式的参数

下面这个代码所定义的函数，用哪一种代码调用会出错？

```java
import java.util.function.Function;
        
public class App {
    public <T, R> product(Function<T, R> consumer) {
        // 省略了 T value 变量 定义代码 
        return consumer(value);
    }
    // 省略其它代码
}
```

## 答案

```java
Predicate<Float> checker = value -> {
    return this.exp(value) < 1;
}
```

## 选项

### lambda 形式

```java
app.product(value -> {
    return sigmod(value);
});
```

### 对象方法

```java
app.product(this::sigmod)
```

### 类型方法

```java
app.product(App::sigmod)
```

### Function 对象

```java
Function<Float, Float> checker = value -> {
    if(this.exp(value) < 1){
        retrun 1/value;
    } else {
        return sigmod(value);
    }
}
```