# UDP


观察以下关于 `TCP` 的程序，服务端和客户端的输出为：

```java
// 省略import
public class TCPClient {
    public static void main(String[] args) throws Exception{
        String[] messages = {"你好！", "我叫小白", "很高兴认识你"};
        Socket socket = new Socket(InetAddress.getLocalHost(),8080);
        OutputStream out = socket.getOutputStream();
        InputStream in = socket.getInputStream();
        for (String message: messages) {
            out.write(message.getBytes());
            byte[] buf = new byte[1024];
            int len = in.read(buf);
            System.out.println(new String(buf,0, len));
        }
        socket.close();
    }
}
```

```java
// 省略import
public class TCPServer {
    public static void main(String[] args) throws Exception {
        String response = "收到";
        ServerSocket serverSocket = new ServerSocket(8080);
        Socket socket = serverSocket.accept();
        while (true) {
            InputStream in = socket.getInputStream();
            byte[] buf = new byte[1024];
            int len = in.read(buf);
            if (len == -1) {
                continue;
            }
            System.out.println(new String(buf,0, len));

            OutputStream out = socket.getOutputStream();
            out.write(response.getBytes());
            Thread.sleep(1000);
        }
    }
}
```

## 答案

```
服务端的输出为：
你好！
我叫小白
很高兴认识你
```

## 选项

### A

```
客户端的输出为：

```

### B

```
服务端的输出为：
￤ﾽﾠ￥ﾥﾽ￯ﾼﾁ
￦ﾈﾑ￥ﾏﾫ￥ﾰﾏ￧ﾙﾽ
￥ﾾﾈ￩ﾫﾘ￥ﾅﾴ￨ﾮﾤ￨ﾯﾆ￤ﾽﾠ
```

### C

```
服务端的输出为：
很高兴认识你
我叫小白
你好！
```
