# Parser 函数

我们的项目中有一个预备好的 `Try<T>` 类型，它可以携带正常对象或异常，只需要调用对应的静态方法
`Try.success(T result)` 或者 `Try.failure(Throwable err)` 即可。

现在我们希望为类型
```java
public abstract class Parser<E, T> {
    public abstract T parse(E element);
}
```
类编写一个静态的 `<T> Parser<Try<T>> pack(Parser<T> E elemenmt)` 方法，它将传
入的 parser 封装，返回一个新的，不会抛出异常的，而是返回 Try 类型的 `Parser<E, Try<T>>` 对象，下面
正确的是

## 答案

```java
public abstract class Parser<E, T> {
    public abstract T parse(E element);
    public static Parser<E, Try<T>> pack(Parser<E, T> parser) {
        return element -> {
            try {
                return Try.success(parser.parse(element));
            } catch(Throwable error){
                return Try.failure(error);
            }
        };
    }
}
```

## 选项

### A

```java
public abstract class Parser<E, T> {
    public abstract T parse(E element);
    public static Try<T> pack(Parser<E, T> parser) {
        return element -> {
            Try<T> result;
            try {
                result = Try.success(parser.parse(element));
            } catch(Throwable error){
                result = Try.failure(error);
            } finally {
                return result;
            }
        };
    }
}
```

### B

```java
public abstract class Parser<E, T> {
    public T parse(E element);
    public Try<T> pack(Parser<E, T> parser) {
        return element -> {
            Try<T> result;
            try {
                result = Try.success(parser.parse(element));
            } catch(Throwable error){
                result = Try.failure(error);
            } finally {
                return result;
            }
        };
    }
}
```

### C

```java
public abstract class Parser<E, T> {
    public abstract T parse(E element);
    public static Parser<E, Try<T>> pack(Parser<E, T> parser) {
        return element -> {
            var result = parser.parse(element);
            if(result instanceof Throwable){
                return Try.failure(result);
            } else {
                return Try.success(result);
            }
        };
    }
}
```

### D

```java
public abstract class Parser<E, T> {
    public abstract T parse(E element);
    public static Parser<E, Try<T>> pack(Parser<E, T> parser) {
        return element -> {
            try {
                var result = parser.parse(element);
                if(result instanceof Throwable){
                    return Try.failure(result);
                } else {
                    return Try.success(result);
                }
            } catch(Throwable error){
                return Try.failure(error);
            }
        };
    }
}
```