# Optional 应用

现有一个 `String content` 字符串，它有可能是 NULL ，也有可能是字符串，那么下列将其转为 Optional 的操作，哪个是错的？

## 答案

```java
var opt = Optional.of(content);
```

## 选项

### 常规方法

```java
var opt = Optional.ofNullable(content);
```

### 平凡方法，不推荐，但可用

```java
Optional<String> opt;
if(content == null){
    opt = Optional.empty();
} else {
    opt = Optional.of(content);
}
```

### C

以上全都可用，没有错误代码
