# Map Reduce

现有一个csv文件，共一千万行数据，每一行数据都是按逗号分隔的浮点数， 其中第一行是表头，需要忽略。假设我们已经得到了这个文件 对应的文本行 stream 对象 `Stream<String> stream`
，现在希望对所有行所有列求和，已知现在我们手上有一个16核的机器，下列 哪一个计算方法最快？

## 答案

```java
stream.drop(1).parallel()
        .flatMap(str->Arrays.stream(str.split(",")))
        .map(Float::parseFloat)
        .reduce(0f,Float::sum);
```

## 选项

### 串行

```java
stream.drop(1)
        .flatMap(str->Arrays.stream(str.split(",")))
        .map(Float::parseFloat)
        .reduce(0f,Float::sum);
```

### 并发不安全

```java
Float result = 0;
stream.drop(1).parallel().forEach(line -> {
    for(var cell: line.split(",")){
        result += Float.parseFloat(cell);
    }
});
```

### 没有并行，无法充分利用 cpu 资源

```java
Float result = 0;
stream.drop(1).forEach(line -> {
    for(var cell: line.split(",")){
        result+=Float.parseFloat(cell);
    }
});
```

### 没有并行

```java
Float result = 0;
stream.drop(1).map(str->Arrays.stream(str.split(","))).forEach(line -> {
    for(var cell: line){
        result+=Float.parseFloat(cell);
    }
});
```
