# Stream To Map

现有类型 Person 如下：

```java
public class Person{
    private final int id;
    private final String name;
    public Person(int id, String name){
        this.id = id;
        this.name = name;
    }
    
    public int getId(){
        return id;
    }
    
    public String getName(){
        return name;
    }
}
```

下面的程序将 `Stream<Person> people` 中的数据整理到一个 Map<Integer, String> 字典中，键和值分别对应 Person 类型的 id 和name。其中有错的是：

## 答案

```java
Map<Integer, String> dict = new Map();

people.collect(p ->{
    dict.put(p.getId(), p.getName());
});
```

## 选项

### 常规收集器

```java
Map<Integer, String> dict = people().collect(Collectors.toMap(Person::getId, Person::getName));
```

### 朴素的过程化方法

```java
Map<Integer, String> dict = new HashMap<>();
people.forEach(p->{
    dict.put(p.getId(), p.getName());
});
```

### 朴素的 for 循环，不推荐但是能用

```java
Map<Integer, String> dict = new HashMap<>();
for(var p: people.toList()){
    dict.put(p.getId(), p.getName());
}
```
