# 翻倍操作

下面哪个选项可以从 `Stream<Integer> stream` 构造一个新的 List<Ineger> 对象，使其包含stream中每个元素翻倍后的结果：

## template

```java
import java.util.stream.Stream;
import java.util.stream.IntStream;

public class App{
    public void main(String[] args){
        Stream<Integer> stream = IntStream.range(0, 100).boxed();
        $code
        for(var item : result){
            System.out.println(item);
        }
    }
}
```

## 答案

```java
List<Integer> result = stream.map(x->x*2).collect(Collectors.toList());
```

## 选项

### 没有变换为 List

```java
List<Integer> result = stream.map(x->x*2);
```

### lambda 格式错误

```java
List<Integer> result = stream.map(* 2).collect(Collectors.toList());
```

###  错误的使用了 foreach

```java
List<Integer> result = stream.foreach(item -> {
    return item * 2
});
```

