# Queue


下列代码用优先级队列实现了任务队列，运行程序控制台输出正确的是：
```java
class Task {
    private String name;
    private int priority;

    public Task(String name, int priority) {
        this.name = name;
        this.priority = priority;
    }
    // 此处省略getter和setter方法
}

public class CollectionsTest {
    public static void main(String[] args) {
        Comparator<Task> cmp = new Comparator<Task>() {
            public int compare(Task o1, Task o2) {
                int diff = o1.getPriority() - o2.getPriority();
                if (diff > 0) {
                    return -1;
                } else if (diff == 0) {
                    return 0;
                }
                return 1;
            }
        };
        Queue<Task> queue = new PriorityQueue<>(cmp);
        queue.add(new Task("a", 8));
        queue.add(new Task("b", 2));
        queue.add(new Task("c", 6));
        queue.add(new Task("d", 1));
        while (!queue.isEmpty()) {
            Task task = queue.poll();
            System.out.print(task.getName());
        }
    }
}
```


## 答案

```
acbd
```

## 选项

### A

```
dbca
```

### B

```
bdca
```

### C

```
acdb
```
