# 查找最大值

下面哪个函数能够从数组中找到最大值(如果数组为空，返回 0)？

## aop

### before

```java
int[] array = new int[]{1, 28766, 3, 4, 75, 32421, 12, 3232, 932};
```


### after

```java
max(array);
```

## 答案

```java

int max(int[] array){
    int result = 0;
    for(int i=0;i<array.length;i++){
        int value = array[i];
        if(value > result){
            result = value;
        }
    }
    return value;
}

```

## 选项

### 符号用反

```java

int max(int[] array){
    int result = 0;
    for(int i=0;i<array.length;i++){
        int value = array[i];
        if(value < result){
            result = value;
        }
    }
    return result;
}

```

### final 无法修改

```java

int max(int[] array){
    final int result = 0;
    for(int i=0;i<array.length;i++){
        int value = array[i];
        if(value > result){
            result = value;
        }
    }
    return result;
}

```

### 错用比较运算符

```java

int max(int[] array){
    final int result = 0;
    for(int i=0;i<array.length;i++){
        int value = array[i];
        if(value > result){
            result == value;
        }
    }
    return result;
}

```